#include <QApplication>
#include <QFileInfo>
#include <QQmlApplicationEngine>
#include <QQmlContext>
#include <QSettings>
#include <QSqlDatabase>

#include "datamodel.h"
#include "datetime.h"
int main(int argc, char* argv[])
{
    QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);

    QApplication app(argc, argv);

    QSqlDatabase db = QSqlDatabase::addDatabase(QStringLiteral("QSQLITE"));
    db.setDatabaseName("/usr/share/medical-data/medData.db");
    db.open();

    QSettings settings(QStringLiteral("myCompany"), QStringLiteral("MedishDemo"), nullptr);
    DateTime myDateTime(nullptr);
    myDateTime.setUtcOffset(settings.value(QStringLiteral("utcOffset"), 0).toInt());
    QObject::connect(&myDateTime, &DateTime::utcOffsetChanged, [&settings, &myDateTime] {
        settings.setValue(QStringLiteral("utcOffset"), myDateTime.utcOffset());
    });

    myDateTime.setScreenSaverTimeout(settings.value(QStringLiteral("screenSaverTimeout"), 60).toInt());
    QObject::connect(&myDateTime, &DateTime::screenSaverTimeoutChanged, [&settings, &myDateTime] {
        settings.setValue(QStringLiteral("screenSaverTimeout"), myDateTime.screenSaverTimeout());
    });

    DataModel dataModel(nullptr, db);
    dataModel.setTable(QStringLiteral("patients"));
    dataModel.select();

    QQmlApplicationEngine engine;
    engine.rootContext()->setContextProperty("dateTime", &myDateTime);
    engine.rootContext()->setContextProperty("dataModel", &dataModel);
    const QUrl url(QStringLiteral("qrc:/main.qml"));
    QObject::connect(
        &engine, &QQmlApplicationEngine::objectCreated,
        &app, [url](QObject* obj, const QUrl& objUrl) {
            if (!obj && url == objUrl)
                QCoreApplication::exit(-1);
        },
        Qt::QueuedConnection);
    engine.load(url);

    return app.exec();
}
